;Starfield 3D utilisant les log/exp.
;Code by Elric/Holocaust.

MAIN	CLR.L	-(SP)
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.W	#6,SP

	CLR.B	$FFFF8260.W
	CLR.B	$FFFFFA07.W
	CLR.B	$FFFFFA09.W

	MOVEQ	#1,D0
	JSR	ZIK

	JMP	DEBUT
ZIK	INCBIN	ZIK.ZIK
DEBUT

	BSR	PREP_ECR
	BSR	PREPA_LOG_EXP

	MOVEQ	#0,D0
	MOVE.L	D0,$FFFF8240.W
	MOVE.L	D0,$FFFF8244.W
	MOVE.L	D0,$FFFF8248.W
	MOVE.L	D0,$FFFF824C.W
	MOVE.L	D0,$FFFF8250.W
	MOVE.L	D0,$FFFF8254.W
	MOVE.L	D0,$FFFF8258.W
	MOVE.L	D0,$FFFF825C.W

	MOVE.L	#EFFAC_1,ADR_EFF
	MOVE.L	#EFFAC_2,ADR_EFF+4
	MOVE.L	#EFFAC_3,ADR_EFF+8
	MOVE.L	#EFFAC_4,ADR_EFF+12
	MOVE.L	#EFFAC_5,ADR_EFF+16
	MOVE.L	#EFFAC_6,ADR_EFF+20
	MOVE.L	#EFFAC_7,ADR_EFF+24
	MOVE.L	#EFFAC_8,ADR_EFF+28
	CLR.W	PLANE

	LEA	COEFF,A0
	LEA	LOGARITHMES+512*2(PC),A1
.CONT	MOVE.W	(A0),D0
	CMPI.W	#$200,D0
	BLE.S	.OK
	MOVEQ	#0,D0
.OK	ADD.W	D0,D0
	MOVE.W	(A1,D0.W),(A0)+
	CMPA.L	#FIN_COEFF,A0
	BLT.S	.CONT

	CLR.W	Z_BASE

	LEA	POINTS+2,A0
	MOVE.W	#300-1,D7
.MULTI	REPT	3
	MOVE.W	(A0),D0
	ADD.W	D0,D0
	MOVE.W	D0,(A0)+
	ENDR
	DBRA	D7,.MULTI

	LEA	SINUS,A0
	LEA	SINUS+LONG_SINUS,A1
	MOVE.W	#(LONG_SINUS/4)-1,D7
.RECOPY	MOVE.W	(A0)+,(A1)+
	DBRA	D7,.RECOPY

	MOVE.L	#VBL_STARS,$70.W

BOUCLE	BRA.S	BOUCLE

CNT	DC	4
VBL_STARS	
	SF	$FFFF8240.W
	BSR	EFFAC

	LEA	POINTS,A0
	LEA	ANGLES,A1
	LEA	TRANS,A6
	LEA	BUF_PTS,A2
	BSR	ROTATE

	LEA	ADR_EFF,A0
	MOVE.L	(A0),D0
;	MOVE.L	(A0),-(A0)
;	MOVE.L	D0,4(A0)
	MOVE.L	4(A0),(A0)+
	MOVE.L	4(A0),(A0)+
	MOVE.L	4(A0),(A0)+
	MOVE.L	4(A0),(A0)+
	MOVE.L	4(A0),(A0)+
	MOVE.L	4(A0),(A0)+
	MOVE.L	4(A0),(A0)+
	MOVE.L	D0,(A0)

	BSR	SWAPEC

	MOVE.W	PLANE,D0
	ANDI.W	#6,D0
	ADD.W	D0,D0
	LEA	ADR_PALETTE,A0
	MOVE.L	(A0,D0.W),A0
MODPAL	EQU	*+2
	LEA	0(A0),A0
	CMPI	#$1234,4*2(A0)
	BEQ.S	.OK
	SUBQ	#1,CNT
	BNE.S	.OK
	MOVE	#4,CNT
	ADDQ	#8,MODPAL
.OK	MOVEM.W	(A0),D0-D3
	MOVE.W	#$8242,A0
	MOVE.W	D0,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D0,(A0)+
	MOVE.W	D2,(A0)+
	MOVE.W	D0,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D0,(A0)+
	MOVE.W	D3,(A0)+
	MOVE.W	D0,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D0,(A0)+
	MOVE.W	D2,(A0)+
	MOVE.W	D0,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D0,(A0)+

	ADDQ.W	#1,PLANE
	ANDI.W	#7,PLANE

	LEA	ANGLES,A0
	MOVE.W	(A0),D0
	ADDI.W	#2,D0	;ANGLE Z
	ANDI.W	#1023,D0
	MOVE.W	D0,(A0)+
	MOVE.W	(A0),D0
	ADDI.W	#1,D0	;ANGLE X
	ANDI.W	#1023,D0
	MOVE.W	D0,(A0)+
	MOVE.W	(A0),D0
	ADDI.W	#1,D0	;ANGLE Y
	ANDI.W	#1023,D0
	MOVE.W	D0,(A0)+
	JSR	ZIK+8
	
	CMPI.B	#$F,$FFFFFC02.W
	BNE.S	.RTE
	ST	$FFFF8240.W
.RTE	RTE

SWAPEC	MOVE.L	SCREEN1,D0
	MOVE.L	SCREEN2,SCREEN1
	MOVE.L	D0,SCREEN2
	MOVE.B	SCREEN1+1,$FFFF8201.W
	MOVE.B	SCREEN1+2,$FFFF8203.W
	RTS

EFFAC	MOVE.L	SCREEN2,A0
	MOVE.W	PLANE,D0
	ANDI.W	#6,D0
	ADDA.W	D0,A0
	MOVEQ	#0,D0
	MOVE.L	ADR_EFF,A1
	JMP	(A1)

EFFAC_1	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_2	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_3	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_4	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_5	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_6	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_7	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS
EFFAC_8	REPT	240
	MOVE.W	D0,0(A0)
	ENDR
	RTS

TABLE_ADR_EFFAC	DC.L	EFFAC_1,EFFAC_2,EFFAC_3,EFFAC_4
	DC.L	EFFAC_5,EFFAC_6,EFFAC_7,EFFAC_8

PALETTE_1	DC.W	0,0,0,0
	DC.W	$001,$000,$000,$000
	DC.W	$112,$000,$000,$000
	DC.W	$223,$000,$000,$001
	DC.W	$334,$000,$000,$112
	DC.W	$445,$000,$001,$223
	DC.W	$556,$001,$112,$334
	DC.W	$667,$112,$223,$445,$1234

PALETTE_2	DC	0,0,0,0
	DC.W	$000,$001,$000,$000
	DC.W	$000,$112,$000,$000
	DC.W	$001,$223,$000,$000
	DC.W	$112,$334,$000,$000
	DC.W	$223,$445,$000,$001
	DC.W	$334,$556,$001,$112
	DC.W	$445,$667,$112,$223,$1234

PALETTE_3	DC	0,0,0,0
	DC.W	$0,$000,$001,$0
	DC.W	$0,$000,$112,$0
	DC.W	$0,$001,$223,$0
	DC.W	$0,$112,$334,$0
	DC.W	$001,$223,$445,$0
	DC.W	$112,$334,$556,$001
	DC.W	$223,$445,$667,$112,$1234

PALETTE_4	DC	0,0,0,0
	DC.W	$0,$0,$0,$001
	DC.W	$0,$0,$0,$112
	DC.W	$0,$0,$001,$223
	DC.W	$0,$0,$112,$334
	DC.W	$0,$001,$223,$445
	DC.W	$001,$112,$334,$556
	DC.W	$112,$223,$445,$667,$1234

ADR_PALETTE	DC.L	PALETTE_1,PALETTE_2,PALETTE_3,PALETTE_4

;ENTRES : A0=TABLE DE POINTS ( .W:NB DE POINTS, ET LES POINTS)
;          A1=TABLE D'ANGLE ( ANGLE X, ANGLE Y, ANGLE Z)
;          A6=TABLE DE TRANSLATION ( U_X, U_Y, U_Z)
;          A2=TABLE DE DESTINATION POUR LES POINTS

;Formules de rotation 3 axes:
;X'=X[SIN(T)SIN(U)SIN(V)+COS(T)COS(V)]+Y[COS(T)SIN(U)SIN(V)-SIN(T)COS(V)]+Z[COS(U)SIN(V)]
;Y'=X[SIN(T)COS(U)]+Y[COS(T)COS(U)]-ZSIN(U)
;Z'=X[SIN(T)SIN(U)COS(V)-COS(T)SIN(V)]+Y[COS(T)SIN(U)COS(V)+SIN(T)SIN(V)]+Z[COS(U)COS(V)]

ROTATE	LEA	SINUS(PC),A4	;SINUS
	LEA	LONG_SINUS/4(A4),A3	;COSINUS

	MOVE.W	(A1)+,D0	;ANGLE_X
	ADD.W	D0,D0
	MOVE.W	(A3,D0.W),D1	;COSINUS TETA_X
	MOVE.W	(A4,D0.W),D0	;SINUS TETA_X

	MOVE.W	(A1)+,D2	;ANGLE_Y
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D3	;COSINUS TETA_Y
	MOVE.W	(A4,D2.W),D2	;SINUS TETA_Y

	MOVE.W	(A1)+,D4	;ANGLE_Z
	ADD.W	D4,D4
	MOVE.W	(A3,D4.W),D5	;COSINUS TETA_Z
	MOVE.W	(A4,D4.W),D4	;SINUS TETA_Z

	LEA	MATRICE,A4
	LEA	LOGARITHMES+512*2(PC),A3
	;ON FABRIQUE SIN(T)*SIN(U)*SIN(V)+COS(T)*COS(V)
	MOVE.W	D0,D6	;D6=SIN(T)
	MULS.W	D2,D6	;D6=SIN(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D4,D6	;D6=SIN(T)*SIN(U)*SIN(V)
	MOVE.W	D1,D7	;D7=COS(T)
	MULS.W	D5,D7	;D7=COS(T)*COS(V)
	ADD.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK1
	MOVE.W	#1*2,D6
.OK1	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(T)*SIN(U)*SIN(V)-SIN(T)*COS(V)
	MOVE.W	D1,D6	;D6=COS(T)
	MULS.W	D2,D6	;D6=COS(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D4,D6	;D6=COS(T)*SIN(U)*SIN(V)
	MOVE.W	D0,D7	;D7=SIN(T)
	MULS.W	D5,D7	;D7=SIN(T)*COS(V)
	SUB.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK2
	MOVE.W	#1*2,D6
.OK2	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(U)*SIN(V)
	MOVE.W	D3,D6	;D6=COS(U)
	MULS.W	D4,D6	;D6=COS(U)*SIN(V)
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK3
	MOVE.W	#1*2,D6
.OK3	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE SIN(T)*COS(U)
	MOVE.W	D0,D6	;D6=SIN(T)
	MULS.W	D3,D6	;D6=SIN(T)*COS(U)
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK4
	MOVE.W	#1*2,D6
.OK4	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(T)*COS(U)
	MOVE.W	D1,D6	;D6=COS(T)
	MULS.W	D3,D6	;D6=COS(T)*COS(U)
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK5
	MOVE.W	#1*2,D6
.OK5	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE -SIN(U)
	MOVE.W	D2,D6
	NEG.W	D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK6
	MOVE.W	#1*2,D6
.OK6	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE SIN(T)*SIN(U)*COS(V)-COS(T)*SIN(V)
	MOVE.W	D0,D6	;D6=SIN(T)
	MULS.W	D2,D6	;D6=SIN(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D5,D6	;D6=SIN(T)*SIN(U)*COS(V)
	MOVE.W	D1,D7	;D7=COS(T)
	MULS.W	D4,D7	;D7=COS(T)*SIN(V)
	SUB.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK7
	MOVE.W	#1*2,D6
.OK7	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(T)*SIN(U)*COS(V)+SIN(T)*SIN(V)
	MOVE.W	D1,D6	;D6=COS(T)
	MULS.W	D2,D6	;D6=COS(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D5,D6	;D6=COS(T)*SIN(U)*COS(V)
	MOVE.W	D0,D7	;D7=SIN(T)
	MULS.W	D4,D7	;D7=SIN(T)*SIN(V)
	ADD.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK8
	MOVE.W	#1*2,D6
.OK8	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(U)*COS(V)
	MULS.W	D3,D5	;D5=COS(U)*COS(V)
	ASR.L	#8,D5
	ADD.W	D5,D5
	TST.W	D5
	BNE.S	.OK9
	MOVE.W	#1*2,D5
.OK9	MOVE.W	(A3,D5.W),(A4)+

	MOVE.W	(A6)+,D0
	ADD.W	D0,D0	;U_X*2
	MOVE.W	D0,TRANSLATE_X
	MOVE.W	(A6)+,D0
	ADD.W	D0,D0	;U_Y*2
	MOVE.W	D0,TRANSLATE_Y
	MOVE.W	(A6),D0
	ADD.W	D0,D0	;U_Z*2
	MOVE.W	D0,TRANSLATE_Z

	MOVE.W	(A0)+,D7	;D7=NB DE POINTS
	SUBQ.W	#1,D7
	MOVE.L	#MATRICE,D6
	LEA	BUF_EXP,A5

	LEA	CORES_X,A1	;A2
	MOVE.L	SCREEN2,A2	;A3
	MOVE.W	PLANE,D0
	ANDI.W	#6,D0
	ADDA.W	D0,A2
	MOVE.W	PLANE,D0
	ADD.W	D0,D0
	ADD.W	D0,D0
	LEA	TABLE_ADR_EFFAC,A6
	MOVE.L	(A6,D0.W),A6
;	MOVE.L	A6,ADR_EFF+28	;A5
	MOVE.L	ADR_EFF,A6
	ADDQ.W	#2,A6

	LEA	LOGARITHMES+512*2(PC),A3

ROTATE_ALL	
	LEA	BUF_CLIP_COOR(PC),A4
	MOVE.W	(A0),D0	;X*2
TRANSLATE_X = *+2
	ADDI.W	#$1234,D0
	MOVE.W	(A4,D0.W),D0
	MOVE.W	D0,(A0)+

	MOVE.W	(A0),D1	;Y*2
TRANSLATE_Y = *+2
	ADDI.W	#$1234,D1
	MOVE.W	(A4,D1.W),D1
	MOVE.W	D1,(A0)+

	MOVE.W	(A0),D2	;Z*2
TRANSLATE_Z = *+2
	ADDI.W	#$1234,D2
	MOVE.W	(A4,D2.W),D2
	MOVE.W	D2,(A0)+

	MOVE.L	D6,A4
	MOVE.W	(A3,D0.W),D0	;D0=LOG(X)
	MOVE.W	(A3,D1.W),D1	;D1=LOG(Y)
	MOVE.W	(A3,D2.W),D2	;D2=LOG(Z)

	MOVE.W	D0,D3	;LOG(X)
	ADD.W	(A4)+,D3	;LOG(X)+LOG(COEFF)
	MOVE.W	(A5,D3.W),D3	;D3=X*COEFF
	MOVE.W	D1,D4	;LOG(Y)
	ADD.W	(A4)+,D4	;LOG(Y)+LOG(COEFF)
	ADD.W	(A5,D4.W),D3
	MOVE.W	D2,D5	;LOG(Z)
	ADD.W	(A4)+,D5	;LOG(Z)+LOG(COEFF)
	ADD.W	(A5,D5.W),D3

	MOVE.W	D0,D4	;LOG(X)
	ADD.W	(A4)+,D4	;LOG(X)+LOG(COEFF)
	MOVE.W	(A5,D4.W),D4	;D4=X*COEFF
	MOVE.W	D1,D5	;LOG(Y)
	ADD.W	(A4)+,D5	;LOG(Y)+LOG(COEFF)
	ADD.W	(A5,D5.W),D4
	MOVE.W	D2,D5	;LOG(Z)
	ADD.W	(A4)+,D5	;LOG(Z)+LOG(COEFF)
	ADD.W	(A5,D5.W),D4

	ADD.W	(A4)+,D0	;LOG(X)+LOG(COEFF)
	MOVE.W	(A5,D0.W),D0	;D3=X*COEFF
	ADD.W	(A4)+,D1	;LOG(Y)+LOG(COEFF)
	ADD.W	(A5,D1.W),D0
	ADD.W	(A4)+,D2	;LOG(Z)+LOG(COEFF)
	ADD.W	(A5,D2.W),D0

	ADDI.W	#COEFF+410*2-CORES_X,D0
	MOVE.W	(A1,D0.W),D0	;LOG DU COEFF 3D
	MOVE.W	(A3,D3.W),D3	;LOG DE X
	ADD.W	D0,D3	;LOG DE X+LOG DE COEFF
	ADD.W	(A3,D4.W),D0	;LOG DE Y+LOG DE COEFF

	MOVE.W	(A5,D3.W),D3
	MOVE.W	(A5,D0.W),D4

	ADDI.W	#CORES_Y-CORES_X,D4
	MOVE.W	(A1,D4.W),D4
	ADD.W	D3,D3
	ADD.W	2(A1,D3.W),D4
	MOVE.W	(A1,D3.W),D3
	OR.W	D3,(A2,D4.W)
	MOVE.W	D4,(A6)
	ADDQ.W	#4,A6

	DBRA	D7,ROTATE_ALL
	RTS

PREPA_LOG_EXP	;ON ARRANGE LA PARTIE NEGATIVE DE LA TABLE DES LOG.
	LEA	LOGARITHMES(PC),A0
	MOVE.W	#512-1,D7
LOG_NEGATIFS	MOVE.W	(A0),D0
	ADD.W	D0,D0
	ADDI.W	#LONG_EXP/2,D0
	MOVE.W	D0,(A0)+
	DBRA	D7,LOG_NEGATIFS
	MOVE.W	#LONG_EXP/2,D7
	MULU.W	#3,D7
	MOVE.W	D7,(A0)+	;D7=LONG_EXP*3 (ZERO)
	MOVE.W	#512-1,D7
LOG_POSITIFS	MOVE.W	(A0),D0
	ADD.W	D0,D0
	MOVE.W	D0,(A0)+	;LOG*2
	DBRA	D7,LOG_POSITIFS

;ON CREE LA PARTIE NEGATIVE ET LA 2EME PARTIE POSITIVE DES EXPONENTIELLES.
	LEA	EXPONENTIELLES(PC),A0
	LEA	BUF_EXP,A1
	LEA	LONG_EXP/2(A1),A2
	LEA	LONG_EXP/2(A2),A3
	MOVE.W	#LONG_EXP/4-1,D7
MAKE_EXP	MOVEQ	#0,D0
	MOVE.L	(A0)+,D0
	LSR.L	#8,D0	;VALEUR REELLE DU RESULTAT
;	ADDI.W	#512,D0
	ADD.W	D0,D0	;*2
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A3)+
	NEG.W	D0
	MOVE.W	D0,(A2)+
	DBRA	D7,MAKE_EXP

;ON CREE LES 2 TABLES DE ZERO LONGUES CHACUNES DE LONG_EXP.
	LEA	BUF_EXP+(LONG_EXP/2)*3,A0
	MOVE.W	#(LONG_EXP/4)*2-1,D7
MAKE_ZERO_TABLE	CLR.W	(A0)+
	DBRA	D7,MAKE_ZERO_TABLE
	RTS

PREP_ECR	MOVE.L	#BUFFER,D0
	CLR.B	D0
	MOVE.L	D0,SCREEN1
	ADDI.L	#32000+1280,D0
	MOVE.L	D0,SCREEN2
	MOVE.B	SCREEN1+1,$FFFF8201.W
	MOVE.B	SCREEN1+2,$FFFF8203.W
	RTS

POINTS	DC.W	230
	INCBIN	random.PTS

ANGLES	DC.W	0,0,0
	;X,Y,Z
TRANS	DC.W	2,2,-6

SINUS	INCBIN	SINUSROT.DAT
LONG_SINUS = *-SINUS
	DCB.W	LONG_SINUS/4,0

	DS.B	500
LOGARITHMES	INCBIN	LOG512.LOG
	DS.B	500

EXPONENTIELLES	INCBIN	EXP512.EXP
LONG_EXP = *-EXPONENTIELLES

	DCB.W	300,0
COEFF	INCBIN	COEFF2.3D
FIN_COEFF

N	SET	-256
	REPT	256
	DC.W	N*2
N	SET	N+1
	ENDR
	REPT	256
	DC.W	N*2
N	SET	N+1
	ENDR
N	SET	-256
	REPT	256
	DC.W	N*2
N	SET	N+1
	ENDR
BUF_CLIP_COOR	REPT	256
	DC.W	N*2
N	SET	N+1
	ENDR
N	SET	-256
	REPT	256
	DC.W	N*2
N	SET	N+1
	ENDR
	REPT	256
	DC.W	N*2
N	SET	N+1
	ENDR

	DCB.W	500,0
N	SET	0
	REPT	10
	DC.W	32768,N,16384,N,8192,N,4096,N,2048,N,1024,N,512,N,256,N,128,N,64,N,32,N,16,N,8,N,4,N,2,N,1,N
N	SET	N+8
	ENDR
CORES_X	REPT	10
	DC.W	32768,N,16384,N,8192,N,4096,N,2048,N,1024,N,512,N,256,N,128,N,64,N,32,N,16,N,8,N,4,N,2,N,1,N
N	SET	N+8
	ENDR
	DCB.W	500,0

	DCB.W	512,-160
N	SET	0
	REPT	100
	DC.W	N
N	SET	N+160
	ENDR
CORES_Y	REPT	100
	DC.W	N
N	SET	N+160
	ENDR
	DCB.W	500,-160

	SECTION	BSS
	DS.B	256+160
BUFFER	DS.B	32000*2+1280
	DS.B	500
SCREEN1	DS.L	1
SCREEN2	DS.L	1
ADR_EFF	DS.L	80
PLANE	DS.L	1
Z_BASE	DS.W	1
MATRICE	DS.W	9
BUF_EXP	DS.W	(LONG_EXP/4)*5
BUF_PTS	DS.W	500*3